---
title: Log Search · Cloudflare Log Explorer docs
description: Log Explorer enables you to store and explore your Cloudflare logs
  directly within the Cloudflare dashboard or API, giving you visibility into
  your logs without the need to forward them to third-party services. Logs are
  stored on Cloudflare's global network using the R2 object storage platform and
  can be queried via the dashboard or SQL API.
lastUpdated: 2025-09-23T09:39:26.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/log-explorer/log-search/
  md: https://developers.cloudflare.com/log-explorer/log-search/index.md
---

Log Explorer enables you to store and explore your Cloudflare logs directly within the Cloudflare dashboard or API, giving you visibility into your logs without the need to forward them to third-party services. Logs are stored on Cloudflare's global network using the R2 object storage platform and can be queried via the dashboard or SQL API.

## Use Log Explorer

You can filter and view your logs via the Cloudflare dashboard or the API.

1. In the Cloudflare dashboard, go to the **Log Explorer** > **Log Search** page.

   [Go to **Log search**](https://dash.cloudflare.com/?to=/:account/log-explorer/log-search)

2. Select the **Dataset** you want to use and in **Columns** select the dataset fields. If you selected a zone scoped dataset, select the zone you would like to use.

3. Enter a **Limit**. A limit is the maximum number of results to return, for example, 50.

4. Select the **Time period** from which you want to query, for example, the previous 12 hours.

5. Select **Add filter** to create your query. Select a **Field**, an **Operator**, and a **Value**, then select **Apply**.

6. A query preview is displayed. Select **Custom SQL** to change the query.

7. Select **Run query** when you are done. The results are displayed below within the **Query results** section.

For example, to find an HTTP request with a specific [Ray ID](https://developers.cloudflare.com/fundamentals/reference/cloudflare-ray-id/), go to **Custom SQL**, and enter the following SQL query:

```sql
SELECT
  clientRequestScheme,
  clientRequestHost,
  clientRequestMethod,
  edgeResponseStatus,
  clientRequestUserAgent
FROM http_requests
WHERE RayID = '806c30a3cec56817'
LIMIT 1
```

As another example, to find Cloudflare Access requests with selected columns from a specific timeframe you could perform the following SQL query:

```sql
SELECT
  CreatedAt,
  AppDomain,
  AppUUID,
  Action,
  Allowed,
  Country,
  RayID,
  Email,
  IPAddress,
  UserUID
FROM access_requests
WHERE Date >= '2025-02-06' AND Date <= '2025-02-06' AND CreatedAt >= '2025-02-06T12:28:39Z' AND CreatedAt <= '2025-02-06T12:58:39Z'
```

### Headers and cookies

To query request headers and cookies, you must first enable logging for these fields using [Custom fields](https://developers.cloudflare.com/logs/logpush/logpush-job/custom-fields/).

The example below shows how to query HTTP requests by date, timestamp, client country, and a custom request header. Be sure to log the specific headers or cookies you plan to query in advance.

```bash
SELECT clientip, clientrequesthost, clientrequestmethod, edgeendtimestamp, edgestarttimestamp, rayid, clientcountry, requestheaders
FROM http_requests
WHERE Date >= '2025-07-17'
  AND Date <= '2025-07-17'
  AND edgeendtimestamp >= '2025-07-17T07:54:19Z'
  AND edgeendtimestamp <= '2025-07-18T07:54:19Z'
  AND clientcountry = 'us'
  AND requestheaders."x-test-header" like '%654AM%';
```

### Save queries

After selecting all the fields for your query, you can save it by selecting **Save query**. Provide a name and description to help identify it later. To view your saved and recent queries, select **Queries** — they will appear in a side panel where you can insert a new query, or delete any query.

## Integration with Security Analytics

You can also access the Log Explorer dashboard directly from the [Security Analytics dashboard](https://developers.cloudflare.com/waf/analytics/security-analytics/#logs). When doing so, the filters you applied in Security Analytics will automatically carry over to your query in Log Explorer.

## Optimize your queries

All the tables supported by Log Explorer contain a special column called `date`, which helps to narrow down the amount of data that is scanned to respond to your query, resulting in faster query response times. The value of `date` must be in the form of `YYYY-MM-DD`. For example, to query logs that occurred on October 12, 2023, add the following to your `WHERE` clause: `date = '2023-10-12'`. The column supports the standard operators of `<`, `>`, and `=`.

1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/login) and select your account.
2. Go to **Log Explorer** > **Log Search** > **Custom SQL**.
3. Enter the following SQL query:

```sql
SELECT
  clientip,
  clientrequesthost,
  clientrequestmethod,
  clientrequesturi,
  edgeendtimestamp,
  edgeresponsestatus,
  originresponsestatus,
  edgestarttimestamp,
  rayid,
  clientcountry,
  clientrequestpath,
  date
FROM
  http_requests
WHERE
  date = '2023-10-12' LIMIT 500
```

### Additional query optimization tips

* Narrow your query time frame. Focus on a smaller time window to reduce the volume of data processed. This helps avoid querying excessive amounts of data and speeds up response times.
* Omit `ORDER BY` and `LIMIT` clauses. These clauses can slow down queries, especially when dealing with large datasets. For queries that return a large number of records, reduce the time frame instead of limiting to the newest `N` records from a broader time frame.
* Select only necessary columns. For example, replace `SELECT *` with the list of specific columns you need. You can also use `SELECT RayId` as a first iteration and follow up with a query that filters by the Ray IDs to retrieve additional columns. Additionally, you can use `SELECT COUNT(*)` to probe for time frames with matching records without retrieving the full dataset.
