---
title: Label client certificates · Cloudflare SSL/TLS docs
description: After creating client certificates at Cloudflare, it may be hard to
  differentiate the generated certificates.
lastUpdated: 2024-08-20T19:58:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/client-certificates/label-client-certificate/
  md: https://developers.cloudflare.com/ssl/client-certificates/label-client-certificate/index.md
---

After [creating client certificates](https://developers.cloudflare.com/ssl/client-certificates/) at Cloudflare, it may be hard to differentiate the generated certificates.

## Root Cause

The option to generate private key and CSR with Cloudflare is meant for simpler cases and the certificates will be generated with just "CN=Cloudflare, C=US".

## Solution

If you need to differentiate client certificates for your clients on a per-organization basis, you can generate your own private key and CSR. When you generate the private key and CSR, you can then enter information that will be incorporated into your certificate request.

For example, if you run the following command (with OpenSSL installed):

```sh
openssl req -new -newkey rsa:2048 -nodes -keyout client1.key -out client1.csr
```

You can then specify:

```plaintext
Country Name (2 letter code) []:
State or Province Name (full name) []:
Locality Name (eg, city) []:
Organization Name (eg, company) []:
Organizational Unit Name (eg, section) []:
Common Name (eg, fully qualified host name) []:
Email Address []:
```

Usually, adding `Country Name` and `Organization Name` is enough, but you can provide as much information as you need or want.

The additional information will be included in the **Certificate Subject**, allowing you to easily identify which certificate belongs to which client. This can also make it easier to revoke a specific certificate when needed.

The following image displays an example of how a certificate with with `Country Name`, `Organization Name`, and `Organizational Unit Name` will look like on the Cloudflare dashboard:

![](https://developers.cloudflare.com/_astro/chrome_mQRJVOpkTQ.BiKeZMXO_Z181z3T.webp)
